using System;

namespace SPStudio
{
	/// <summary>
	/// Contains x,y components to
	/// represent a point in 2D.
	/// Also knows how to convert itself
	/// into a Vector3D.
	/// </summary>
	public class Vector2D
	{
		#region Private Vars
		private double x = 0.0;
		private double y = 0.0;
		#endregion

		#region Constructors
		/// <summary>
		/// Leaves the x,y component
		/// to their original values
		/// of 0.0
		/// </summary>
		public Vector2D()
		{
		}

		/// <summary>
		/// Initialize the x,y components
		/// by converting the x,y components
		/// of the input Point to doubles.
		/// </summary>
		/// <param name="P"></param>
		public Vector2D(System.Drawing.Point P)
		{
			x = (double)P.X;
			y = (double)P.Y;
		}
		#endregion

		#region Conversion to Vector3D
		/// <summary>
		/// Return a new Vector3D with
		/// this vector's x,y components
		/// and a 0.0 z component.
		/// </summary>
		/// <returns></returns>
		public Vector3D convertToVector3D()
		{
			return new Vector3D(x,y,0.0);
		}
		#endregion
	}
}
